/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.metal;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.forge.ForgeableHeatableHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.items.ItemArmorTFC;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemMetalArmor
extends ItemArmorTFC
implements IMetalItem,
IItemSize {
    private static final Map<Metal, EnumMap<Metal.ItemType, ItemMetalArmor>> TABLE = new HashMap<Metal, EnumMap<Metal.ItemType, ItemMetalArmor>>();
    private final Metal metal;
    private final Metal.ItemType type;

    public static ItemMetalArmor get(Metal metal, Metal.ItemType type) {
        return TABLE.get((Object)metal).get((Object)type);
    }

    public ItemMetalArmor(Metal metal, Metal.ItemType type) {
        super(metal.getArmorMetal(), type.getArmorSlot(), type.getEquipmentSlot());
        this.metal = metal;
        this.type = type;
        if (!TABLE.containsKey((Object)metal)) {
            TABLE.put(metal, new EnumMap(Metal.ItemType.class));
        }
        TABLE.get((Object)metal).put(type, this);
    }

    @Override
    @Nullable
    public Metal getMetal(ItemStack stack) {
        return this.metal;
    }

    @Override
    public int getSmeltAmount(ItemStack stack) {
        if (!this.func_77645_m() || !stack.func_77951_h()) {
            return this.type.getSmeltAmount();
        }
        double d = (double)(stack.func_77958_k() - stack.func_77952_i()) / (double)stack.func_77958_k() - 0.1;
        return d < 0.0 ? 0 : MathHelper.func_76128_c((double)((double)this.type.getSmeltAmount() * d));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ForgeableHeatableHandler(nbt, this.metal.getSpecificHeat(), this.metal.getMeltTemp());
    }

    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack stack) {
        switch (this.metal.getTier()) {
            case TIER_I: 
            case TIER_II: {
                return EnumRarity.COMMON;
            }
            case TIER_III: {
                return EnumRarity.UNCOMMON;
            }
            case TIER_IV: {
                return EnumRarity.RARE;
            }
            case TIER_V: {
                return EnumRarity.EPIC;
            }
        }
        return super.getForgeRarity(stack);
    }
}

